local addonName = ...

local pinSize = 14

local wipe = wipe or table.wipe

-- Simple pin pool (avoids recreating frames constantly)
local activePins = {}
local freePins = {}

local function CreatePin(parent)
    local pin = CreateFrame("Frame", nil, parent)
    pin:SetSize(pinSize, pinSize)

    local texture = pin:CreateTexture(nil, "OVERLAY")
    texture:SetAllPoints()
    texture:SetTexture("Interface\\TARGETINGFRAME\\UI-RaidTargetingIcon_1")

    pin.texture = texture

    pin.text = pin:CreateFontString(nil, "OVERLAY", "GameFontNormalSmall")
    pin.text:SetPoint("TOP", pin, "BOTTOM", 0, -2)

    return pin
end

local function AcquirePin(parent)
    local pin = table.remove(freePins)
    if not pin then
        pin = CreatePin(parent)
    else
        pin:SetParent(parent)
    end

    pin:Show()
    activePins[#activePins + 1] = pin
    return pin
end

local function ReleaseAllPins()
    for i = 1, #activePins do
        local pin = activePins[i]
        pin:Hide()
        pin:ClearAllPoints()
        pin.text:SetText("")
        freePins[#freePins + 1] = pin
    end
    wipe(activePins)
end

local function GetWorldMapID()
    if not WorldMapFrame then return nil end
    if WorldMapFrame.GetMapID then
        return WorldMapFrame:GetMapID()
    end
    return WorldMapFrame.mapID
end

local function GetWorldMapCanvas()
    if not WorldMapFrame or not WorldMapFrame.ScrollContainer then return nil end

    local sc = WorldMapFrame.ScrollContainer
    if sc.GetCanvas then
        return sc:GetCanvas()
    end
    return sc.Child
end

function GuildMap_UpdatePins()
    if not WorldMapFrame then return end

    local mapID = GetWorldMapID()
    if not mapID then
        ReleaseAllPins()
        return
    end

    local canvas = GetWorldMapCanvas()
    if not canvas then
        ReleaseAllPins()
        return
    end

    ReleaseAllPins()

    for name, data in pairs(GuildMapData.locations) do
        if data.mapID == mapID and (GetTime() - data.time < 15) then
            local pin = AcquirePin(canvas)

            local width = canvas:GetWidth()
            local height = canvas:GetHeight()
            if width <= 0 or height <= 0 then
                -- Canvas isn't fully laid out yet; try again shortly.
                if C_Timer and C_Timer.After then
                    C_Timer.After(0, GuildMap_UpdatePins)
                end
                return
            end

            pin:SetPoint("CENTER", canvas, "TOPLEFT", data.x * width, -data.y * height)
            pin.text:SetText(name)
        end
    end
end
