local addonName = ...
local prefix = "GUILDMAP"
local updateInterval = 5
local elapsed = 0

GuildMapData = GuildMapData or {}
GuildMapData.locations = GuildMapData.locations or {}

-- Register addon comm prefix
C_ChatInfo.RegisterAddonMessagePrefix(prefix)

-- Frame for event handling
local frame = CreateFrame("Frame")
frame:RegisterEvent("PLAYER_LOGIN")
frame:RegisterEvent("ADDON_LOADED")
frame:RegisterEvent("CHAT_MSG_ADDON")

-- Send your location to guild channel
local function SendLocation()
    if not IsInGuild() then return end

    local mapID = C_Map.GetBestMapForUnit("player")
    if not mapID then return end

    local pos = C_Map.GetPlayerMapPosition(mapID, "player")
    if not pos then return end

    local msg = string.format("%d;%.4f;%.4f;%s", mapID, pos.x, pos.y, UnitName("player"))
    C_ChatInfo.SendAddonMessage(prefix, msg, "GUILD")
end

local function SetupWorldMapHooks()
    if frame._worldMapHooksInstalled then return end
    if not WorldMapFrame then return end

    frame._worldMapHooksInstalled = true

    -- Refresh pins when the map is opened, closed, resized, or changed.
    if WorldMapFrame.HookScript then
        WorldMapFrame:HookScript("OnShow", GuildMap_UpdatePins)
        WorldMapFrame:HookScript("OnHide", GuildMap_UpdatePins)
    end

    if WorldMapFrame.ScrollContainer and WorldMapFrame.ScrollContainer.HookScript then
        WorldMapFrame.ScrollContainer:HookScript("OnCanvasSizeChanged", GuildMap_UpdatePins)
    end

    -- Some clients expose OnMapChanged; if present, use it.
    if WorldMapFrame.OnMapChanged then
        hooksecurefunc(WorldMapFrame, "OnMapChanged", GuildMap_UpdatePins)
    end
end

-- Receive guildmate location
local function ReceiveLocation(msg, sender)
    if sender == UnitName("player") then return end

    local mapID, x, y, name = strsplit(";", msg)
    mapID = tonumber(mapID)
    x = tonumber(x)
    y = tonumber(y)

    GuildMapData.locations[name] = {
        mapID = mapID,
        x = x,
        y = y,
        time = GetTime()
    }

    GuildMap_UpdatePins()
end

-- Event handler
frame:SetScript("OnEvent", function(self, event, ...)
    if event == "PLAYER_LOGIN" then
        print("GuildMap loaded. Guildmates must also run addon to be shown.")
        SetupWorldMapHooks()
    elseif event == "CHAT_MSG_ADDON" then
        local pfx, msg, channel, sender = ...
        if pfx == prefix then
            ReceiveLocation(msg, sender)
        end
    elseif event == "ADDON_LOADED" then
        local loaded = ...
        if loaded == "Blizzard_WorldMap" then
            SetupWorldMapHooks()
        end
    end
end)

-- Timer update to send periodic location
frame:SetScript("OnUpdate", function(self, delta)
    elapsed = elapsed + delta
    if elapsed >= updateInterval then
        SendLocation()
        elapsed = 0
    end
end)
